function [x,afx,i,ind] = steffensen(x0,TOL,N0)
% function [x,afx,i,ind] = steffensen(x0,[TOL,N0]);
% Berechnet eine Nullstelle von f(x) mit dem 
% Steffenson-Verfahren
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
% 
% x0: Startwert, 
% TOL: Toleranz,
% N0: maximale Iterationsschrittanzahl, 
% x: letzte Iterierte,
% i: benoetigte Anzahl an Iterationen,
% ind: Information ueber den Rechenverlauf, mit:
% ind=1: Verfahren konvergiert, 'Loesung' x ist berechnet,
% ind=2: maximale Iterationsschrittanzahl N0 ueberschritten.
%
i=0; x=x0;
if nargin < 2, TOL=1e-12; N0=100; end
while i < N0
    x1=g(x); x2=g(x1); dx=(x1-x)^2/(x2-2*x1+x); x=x-dx; 
    if abs(dx) < TOL*(1+abs(x))
% x ist 'Loesung'       
       ind=1; afx=abs(x-g(x)); return    
    end
    i=i+1;
end
% maximale Iterationsschrittanzahl N0 ueberschritten
afx=abs(x-g(x));
ind=2;
end