function [x,k]=sor(a,b,x1,omega,tol,imax)
% function [x,k] = gesamtschritt(a,b,x1,omega,tol,imax)
% Berechnet eine Naeherung fuer die Loesung eines linearen 
% Gleichungssystems Ax=b mit dem SOR-Verfahren.
% Voraussetzung: die Matrix A ist strikt diagonaldominant
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% x: Loesungsvektor, k: verwendete Anzahl von 
% Iterationsschritten, 
% a: Systemmatrix, b: rechte Seite, x1: Startvektor, 
% omega: Relaxationsparameter, 
% tol: vorzugebende Genauigkeitsschranke, 
% imax: maximale Anzahl von Iterationsschritten 
%
n=length(b);

% Test auf Diagonaldominanz
alpha = true;
for r = 1:n
    beta = 2 * abs(a(r,r)) > sum(abs(a(r,:)));
    alpha = alpha && beta;
end
if alpha == 0
    disp (['Matrix A ist nicht diagonaldominant']); return
elseif alpha == 1
        disp (['Matrix A is diagonaldominant']); 
end

 k = 1;
 while  k <= imax
   err = 0;

   for i = 1 : n
      s = 0;
      for j = 1 : n
        s = s-a(i,j)*x1(j);
      end
      s = omega*(s+b(i))/a(i,i);
      if abs(s) > err
         err = abs(s);
      end
      x1(i) = x1(i)+s;
   end
  
   if err <= tol 
      break;
   else

      k = k+1;
   end
 end
x=x1;
 
