function [x,afx,i,ind] = sekante(x0,x1,TOL,N0)
% function [x,afx,i,ind] = sekante(x0,x1,[TOL,N0])
% Berechnet eine Nullstelle von f(x) mit dem 
% Sekanten-Verfahren
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% x0,x1: Startwerte,
% TOL: Toleranz,
% N0: maximale Iterationsschrittanzahl, 
% x: letzte Iterierte,
% afx: abs(f(x)),
% i: benoetigte Anzahl an Iterationen,
% ind: Information ueber den Rechenverlauf, mit:
% ind=1: Verfahren konvergiert, 'Loesung' x ist berechnet,
% ind=2: maximale Iterationsschrittanzahl N0 ueberschritten.
%
i=0; qa=f(x0); qn=f(x1);
if nargin < 3, TOL=1e-12; N0=100; end
if abs(qa) > abs(qn)
   xa=x0; xn=x1;
else
   xa=x1; xn=x0; s=qn; qn=qa; qa=s;
end
while i < N0
    s=qn/qa; r=1-s; t=s*(xa-xn); x=xn-t/r; fx=f(x); 
    if t == 0
% Sekanten-Verfahren nicht durchfuehrbar
       ind=3; return
    end
    x=xn-t/r; 
    if abs(fx) < TOL
% x ist 'Loesung'      
       ind=1; afx=abs(f(x)); return
    end 
    if abs(x-xn) < TOL*(1+abs(x))
% x ist 'Loesung'       
       ind=1; afx=abs(f(x)); return
    end
    i=i+1;
    if abs(fx) > abs(qn)
       xa=x; qa=fx;
    else
       xa=xn; qa=qn; xn=x; qn=fx;
    end
end
% maximale Iterationsschrittanzahl N0 ueberschritten
afx=abs(f(x));
ind=2;
end