function [Q,R] = qrhouse(A)
% function [Q,R] = qrhouse(A)
% Berechnet die QR-Faktorisierung von A mit 
% Householder-Reflexionen
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% A: (n x m)-Matrix, n >= m,
% Q: orthogonale (n x n)-Matrix,
% R: (n x m)-Matrix mit oberer(m x m)-Dreiecksmatrix.
%
[n,m]=size(A);
Q=eye(n);
for k=1:m    
    v=A(k:n,k);
    nx=norm(v);
    if nx ~= 0
        alpha=sign(v(1))*nx;
        v(1)=v(1)+alpha;
        v=v/norm(v);  % damit ist v'*v=1
% Q = Q * H        
        Q(:,k:n)=Q(:,k:n)-2*(Q(:,k:n)*v)*v';
% A = H * A
        A(k:n,k+1:m)=A(k:n,k+1:m)-2*v*(v'*A(k:n,k+1:m));
        A(k,k)=-alpha;
    else
        error('Matrix A hat nicht vollen Rang')
    end
end
R=triu(A);
end