function [Q,R] = qrgivens(A)
% function [Q,R] = qrgivens(A)
% Berechnet die QR-Faktorisierung von A mit 
% Givens-Rotationen
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% A: (n x m)-Matrix, n >= m,
% Q: orthogonale (n x n)-Matrix,
% R: (n x m)-Matrix mit oberer(m x m)-Dreiecksmatrix.
%
[n,m]=size(A);
Q=eye(n);
for k=1:m
    [~,l]=max(abs(A(k+1:n,k)));
    l=l+k;
    if A(k,k)==0 && A(l,k)==0,
     error('Matrix A hat nicht vollen Rang'),
    end
    j=find(A(k+1:n,k)~=0)+k;
    j=[l;j(j~=l)]';
    for l=j
        [G,x]=givens(A(k,k),A(l,k));
        Q([k,l],:)=G*Q([k,l],:);
        A(k,k)=x(1);
        A(l,k)=0;
        A([k,l],k+1:m)=G*A([k,l],k+1:m);
    end
end
Q=Q';
R=triu(A);
end