function [Q,R,k]=qralg(A,Tol,kmax)
% function [Q,R,k]=qralg(A,[Tol,kmax])
% Berechnet die Eigenwerte und Eigenvektoren einer 
% symmetrischen Matrix mit der QR-Iteration
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% A: symmetrische (n x n)-Matrix,
% Tol: gewuenschte Genauigkeit,
% kmax: maximale Iterationszahl,
% Q: in den Spalten sind die normierten Eigenvektoren von A,
% R: die Eigenwerte von A sind auf der Diagonalen von R,
% k: benoetigte Anzahl an Iterationen.
%
[n,m]=size(A);
if n ~= m, error('Matrix A nicht quadratisch!'), end
if nargin < 2, Tol=1e-14; kmax=n*50; end
Q=eye(n);
for k=1:n-2   
    v=A(k+1:n,k); nx=norm(v);
    if nx ~= 0
        alpha=sign(v(1))*nx; v(1)=v(1)+alpha; 
        v=v/norm(v);  % damit ist v'*v=1
% Q = Q * H        
        Q(:,k+1:n)=Q(:,k+1:n)-2*(Q(:,k+1:n)*v)*v';
% A = H * A * H
        A(k+1:n,k+1:n)=A(k+1:n,k+1:n) ...
                       -2*v*(v'*A(k+1:n,k+1:n));
        A(k+1:n,k+1:n)=A(k+1:n,k+1:n) ...
                       -2*(A(k+1:n,k+1:n)*v)*v';
        A(k+1,k)=-alpha; A(k,k+1)=-alpha;
    else
        error('Matrix A hat nicht vollen Rang')
    end
end
A=triu(A,-1)-triu(A,2);
for k=1:kmax
    [QQ,R]=qrgivens(A); d1=diag(R,1); Q=Q*QQ;
    if norm(d1,inf) < Tol, R=diag(diag(R)); return
    end
    A=R*QQ;    
end
end