function [wu,q,e,r,s,i,ind]=qd(a,TOL,N0)
% function [wu,q,e,r,s,i,ind]=qd(a,[TOL,N0])
% Berechnet die reellen und komplexen Wurzeln des 
% Polynoms P(x) mit dem QD-Verfahren
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% a: Polynomkoeffizenten des Polynoms 
% P(x)=a1+a2*x+...+an-1*x^n,
% TOL: Toleranz,
% N0: maximale Iterationsschrittzahl,
% wu:  alle approximierten Wurzeln des Polynoms,
% q, e: Information ueber die approximierten 
% reellen Wurzeln,
% r, s: approximierte quadratische Faktoren,
% i: Iterationsanzahl,
% ind(i)>0 Information ueber die Konvergenz der appromierten 
% reellen Wurzeln,
% ind(i)=it Verfahren konvergiert, 'i-te reelle Wurzel' 
% wurde im i-ten Iterationsschritt approximiert.
% 
n=length(a)-1;
if nargin < 2, TOL=1e-6; N0=200*n; end
e=zeros(n+1,N0); q=zeros(n,N0); r=zeros(n,N0); 
s=zeros(n,N0); ind=zeros(n,1); wu=NaN*ind;
q(1,1)=-a(n-1+1)/a(n+1);
for k=2:n
    e(k,1)= a(n-k+1)/a(n-k+2);
    ind(k)=0;
end
for i=2:N0
    e(n+1,i)=0;
    q(1,i) = e(2,i-1)+q(1,i-1) - e(1,i-1);
    for k=2:n
        q(k,i) = e(k+1,i-1) + q(k,i-1)-e(k,i-1);
        if q(k-1,i)== 0, error('q=0'),end
        e(k,i) = (q(k,i)*e(k,i-1))/q(k-1,i);
        r(k,i) = q(k-1,i) + q(k,i); 
        s(k,i) = q(k-1,i-1)*q(k,i); 
    end
    for  k=2:n
        if abs(e(k,i))< TOL 
          if ind(k-1) == 0,  ind(k-1) = i; end            
        end
    end
   ind(n)=(sum(ind(1:n-1))==n-1);
   if ind(n) == 1, break, end
end
q=q(:,i); s=s(:,i); r=r(:,i); e=e(:,i);
iw=1;
for j=1:n       
    if ind(j) >= 1
        if iw > n, break, end
        wu(iw) = q(iw); iw=iw+1;
        if iw == n
            wu(iw) = q(iw); break
        end
    else
        if iw > n-1, break, end
        wu([iw,1+iw])=qpol(-r(iw+1),s(iw+1),TOL); iw=iw+2;
    end    
end
end
%
function qw=qpol(p,q,TOL)
d=p^2/4-q;
if d > 0, qw=[NaN;NaN]; return, end
wd=sqrt(-d);
if wd < TOL, wd=0; end
qw=[-p/2+1i*wd;-p/2-1i*wd];
end