function [ew,ev]=potenz(A,tol,kmax)
% function [ev,ew]=potenz(A,[tol,kmax])
% Berechnet fuer die Matrix A den betragsmaessig groessten 
% Eigenwert und den zugehoerigen Eigenvektor mit der 
% Potenzmethode
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% A: (n x n)-Matrix,
% tol: gewuenschte relative Genauigkeit,
% kmax: maximale Iterationszahl,
% ew: Eigenwert von A, 
% ev: normierter Eigenvektor von A.
%
[n,m]=size(A);
if n ~= m, error('Matrix A nicht quadratisch!'), end
if nargin == 1, tol=1e-15; kmax=50*n; end
ev=ones(n,1);
p=1;
ew=1;
for k=1:kmax
    y=A*ev;
    ewn=y(p);
    dew=ewn-ew;
    ew=ewn;
    [~,p]=max(abs(y));
    if y(p) ~= 0
    ev=y/y(p);
    if abs(dew)/(abs(ew)+eps) < tol, break, end
    else
        ew=0;
        ev=0*ev;
        return
    end
end
end