function [x,afx,i,ind] = newtond1(x0,delta,rho,TOL,N0)
% function [x,afx,i,ind] = newtond1(x0,[delta,rho,TOL,N0])
% Berechnet eine Nullstelle von f(x) mit dem gedaempften 
% Newton-Verfahren
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% x0: Anfangsapproximation,  
% 0 < delta,rho < 1: Verfahrenskonstanten,
% TOL: Toleranz, 
% N0: maximale Iterationsschrittanzahl,
% x: letzte Iterierte,
% afx: abs(f(x),
% i: benoetigte Anzahl an Iterationen,
% ind: Information ueber den Rechenverlauf, mit:
% ind=1: Verfahren konvergiert, 'Loesung' x ist berechnet,
% ind=2: Zuwachs zu klein, 
% ind=3: maximale Iterationsschrittanzahl N0 ueberschritten 
% oder Ableitung gleich Null, 
%
x=x0; i=0; lambda=1;
if nargin < 2, delta=0.01; rho=0.5; TOL=1e-12; N0=100; end
while i < N0
    fx=f(x);
    if abs(fx) < TOL
% x ist 'Loesung'      
        ind=1; afx=abs(fx); return
    end    
    fsx=fstrich(x);   
    if fsx == 0
% Newtonverfahren nicht durchfuehrbar      
        ind=3;  afx=abs(f(x));return
    end 
    y=-fx/fsx;
    while f(x+lambda*y)^2 > (1+2*delta*lambda ...
                             +delta*lambda^2)*fx^2
        lambda=rho*lambda;
    end
    x=x+lambda*y; i=i+1;
    if abs(lambda*y) < TOL*(1+abs(x))
% x ist 'Loesung'       
        ind=2; afx=abs(f(x)); return
    end
    lambda=min(lambda/rho,1);
end
% maximale Iterationsschrittanzahl N0 ueberschritten
afx=abs(f(x));
ind=3;  
end