function [x,nFx,i,ind] = newtond(x0,TOL,N0)
% function [x,nFx,i,ind] = newtond(x0,[TOL,N0])
% Berechnet eine Nullstelle von F(x) mit dem gedaempften 
% Newton-Verfahren
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% x0: Startvektor, 
% TOL: Toleranz,
% N0: maximale Iterationsschrittanzahl,
% x: letzte Iterierte,
% nFx: norm(F(x)),  
% i: benoetigte Anzahl an Iterationen,
% ind: Information ueber den Rechenverlauf, mit:
% ind=1: Verfahren konvergiert, 'Loesung' x ist berechnet,
% ind=2: maximale Iterationsschrittanzahl N0 ueberschritten,
% ind=3: Abbruch wegen lambda < lambdamin.
%
x=x0(:);n=length(x0); i=0; la=1;
if nargin < 2, TOL=1e-12; N0=100*n; end
lamin=2^-30;
while i < N0
Fx=F(x);
if norm(Fx) < TOL
% x ist 'Loesung'
ind=1; nFx=norm(F(x)); return
end
Jx=Fstrich(x);
% Loesung des linearen Gleichungssystems Jx*y=-Fx
[L,U,P]=lu(Jx);
z=L\(P*Fx);
y=-U\z;
xx=x+la*y;
Fxx=F(xx);
z=L\(P*Fxx);
yd=-U\z;
% lambda-Steuerung
while norm(yd) > (1-la/2)*norm(y)
    la=la/2;
    if la < lamin, ind=3; nFx=norm(F(x)); return, end
    xx=x+la*y;
    Fxx=F(xx);
    z=L\(P*Fxx);
    yd=-U\z;
end
i=i+1; x=x+la*y; la=min(1,2*la);
end
% maximale Iterationsschrittanzahl N0 ueberschritten
nFx=norm(F(x));
ind=2;