function [x,afx,i,ind] = newton1(x0,TOL,N0)
% function [x,afx,i,ind] = newton1(x0,[TOL,N0])
% Berechnet eine Nullstelle von f(x) mit dem 
% Newton-Verfahren
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% x0: Startwert, 
% TOL: Toleranz,  
% N0: maximale Iterationsschrittanzahl, 
% x: letzte Iterierte,
% afx: abs(f(x)), 
% i: benoetigte Anzahl an Iterationen,
% ind: Information ueber den Rechenverlauf, mit:
% ind=1: Verfahren konvergiert, 'Loesung' x ist berechnet,
% ind=2: maximale Iterationsschrittanzahl N0 ueberschritten.
%
x=x0; i=0;
if nargin < 2, TOL=1e-12; N0=100; end
while i < N0
    fx=f(x); 
    if abs(fx) < TOL
% x ist 'Loesung'      
       ind=1; afx=abs(f(x)); return
    end 
    fsx=fstrich(x);
    if fsx == 0
% Newton-Verfahren nicht durchfuehrbar      
       ind=3; afx=abs(f(x)); return
    end 
% Loesung der linearen Gleichung fsx*y=-fx   
    y=-fx/fsx;
    if abs(y) < TOL*(1+abs(x))
% x ist 'Loesung'       
       ind=1; afx=abs(f(x)); return
    end
    i=i+1; x=x+y; 
end
% maximale Iterationsschrittanzahl N0 ueberschritten
afx=abs(f(x));
ind=2;