function [x,nFx,i,ind] = newton(x0,TOL,N0)
% function [x,nFx,i,ind] = newton(x0,[TOL,N0])
% Berechnet eine Nullstelle von F(x) mit dem 
% Newton-Verfahren und dem natuerlichen Monotonie-Test
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% x0: Startvektor, 
% TOL: Toleranz,
% N0: maximale Iterationsschrittanzahl,
% x: letzte Iterierte, 
% i: benoetigte Anzahl an Iterationen,
% nFx: norm(F(x)), 
% ind: Information ueber den Rechenverlauf, mit:
% ind=1: Verfahren konvergiert, 'Loesung' x ist berechnet,
% ind=2: maximale Iterationsschrittanzahl N0 ueberschritten,
% ind=3: natuerlicher Monotonie-Test verletzt.
%
x=x0(:); i=0; n=length(x0);
if nargin < 2, TOL=1e-12; N0=100*n; end
while i < N0
Fx=F(x);
if norm(Fx) < TOL
% x ist 'Loesung'
ind=1; nFx=norm(F(x)); return
end
Jx=Fstrich(x);
% Loesung des linearen Gleichungssystems Jx*y=-Fx
[L,U,P]=lu(Jx);
z=L\(P*Fx);
y=-U\z;
xx=x+y;
Fxx=F(xx);
z=L\(P*Fxx);
yd=-U\z;
if norm(yd)>.95*norm(y), ind=3; nFx=norm(F(x)); return,end
i=i+1; x=x+y;
end
% maximale Iterationsschrittanzahl N0 ueberschritten
nFx=norm(F(x));
ind=2;