function [x,i,ind] = nachit(x0,A,b,L,U,p,TOL1,TOL2,N0)
% function [x,i,ind] = nachit(x0,A,b,L,U,[p],[TOL1,TOL2,N0])
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
% Verbesserung einer Naeherungsloesung des linearen 
% Gleichungssystems Ax=b mit (mindestens) einem Schritt 
% der Nachiteration
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% x0: Naeherung fuer x=inv(A)*b, 
% A: Systemmatrix des Gleichungssystems,
% b: rechte Seite des Gleichungssystems,
% L,U: Faktoren der LU-Faktorisierung von A,
% p: Pivotisierungsvektoren,
% TOL1 und TOL2: Toleranzen,
% N0: maximale Iterationsschrittanzahl.
% ,
% x: letzte Iterierte, 
% i: benoetigte Anzahl an Iterationen,
% ind: Information ueber den Rechenverlauf, mit: 
% ind=1: Verfahren konvergiert, 'Loesung' x ist berechnet,
% ind=2:  maximale Iterationsschrittanzahl N0 
%         ueberschritten.
%
n=length(x0);
x=x0; i=0;
if ~exist('p','var'),p=(1:n)';end
if nargin < 7, TOL1=1e-15; TOL2=1e-15; N0=100; end
while i < N0
% Berechnung des Residuums mit dem Kahan-Babuska-Trick
    r=0*x;
    for k=1:n
        s=0;ds=0;
        z=A(k,:)'.*x;
        for j=1:n
            sn=s+z(j);
            xs=sn-s;
            dx=z(j)-xs;
            ds=ds+dx;
            s=sn;
        end
        s=s+ds;
        r(k)=s; 
    end
    r=b-r;
% Residuum berechnet   
%
% Loesung des linearen Gleichungssystems A*w=r
% unter Verwendung der LU-Faktorisierung von A
    w=vorsubs(L,r(p));
    w=ruecksubs(U,w);
    i=i+1; x=x+w; 
    if norm(r) < TOL1*(1+norm(b))    % x ist 'Loesung'    
        ind=1; return
    end  
    if norm(w) < TOL2*(1+norm(x))    % x ist 'Loesung'       
        ind=1; return
    end
end
% maximale Iterationsschrittanzahl N0 ueberschritten
ind=2;