function [L,U,p,q]=luvoll(A)
% function [L,U,p,q]=luvoll(A)
% Berechnet die LU-Faktorisierung mit vollstaendiger 
% Pivotisierung
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% A: (n x n)-Matrix,
% L: untere (n x n)-1-Dreiecksmatrix-Matrix,
% U: obere (n x n)-Dreiecksmatrix-Matrix,
% p,q: Permutationsvektoren mit  L * U = A(p,q).
%
[n,m]=size(A);
if n ~= m, error('Matrix A nicht quadratisch!'), end
p=1:n;q=p;
for k=1:n-1
    [ma,j]=max(abs(A(k:n,k:n)));
    [~,l]=max(ma);
    j=j(l)+k-1;l=l+k-1;
    if A(j,l) ~= 0
        if j~=k
            A([k,j],:)=A([j,k],:);
            p([k,j])=p([j,k]);
        end
        if l~=k
            A(:,[k,l])=A(:,[l,k]);
            q([k,l])=q([l,k]);
        end
        A(k+1:n,k)=A(k+1:n,k)/A(k,k);
        A(k+1:n,k+1:n)=A(k+1:n,k+1:n)-A(k+1:n,k)*A(k,k+1:n);
    else
        error('Matrix A ist singulaer')
    end
end
U=triu(A);
L=tril(A,-1)+eye(n);