function [L,U]=lupur(A)
% function [L,U]=lupur(A)
% Berechnet die LU-Faktorisierung ohne Pivotisierung 
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% A: (n x n)-Matrix,
% L: untere (n x n)-1-Dreiecksmatrix-Matrix,
% U: obere (n x n)-Dreiecksmatrix-Matrix.
%
[n,m]=size(A);
if n ~= m, error('Matrix A nicht quadratisch!'), end
for k=1:n-1
    if A(k,k) ~= 0
        A(k+1:n,k)=A(k+1:n,k)/A(k,k);
        A(k+1:n,k+1:n)=A(k+1:n,k+1:n)-A(k+1:n,k)*A(k,k+1:n);
    else
        error('Verfahren nicht durchfuehrbar!')
    end
end
U=triu(A);
L=tril(A,-1)+eye(n);