function [L,U,p]=lupart(A)
% function [L,U,p]=lupart(A)
% Berechnet die LU-Faktorisierung mit Spalten-Pivotisierung
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% A: (n x n)-Matrix,
% L: untere (n x n)-1-Dreiecksmatrix-Matrix,
% U: obere (n x n)-Dreiecksmatrix-Matrix,
% p: Permutationsvektor mit A(p,:) = L * U (Variante 2).
%
[n,m]=size(A);
if n ~= m, error('Matrix A nicht quadratisch!'), end
p=1:n;
for k=1:n-1
    [~,j]=max(abs(A(k:n,k)));
    j=j+k-1;
    if A(j,k) ~= 0
        if j~=k
            A([k,j],:)=A([j,k],:);
         %   L([k,j],1:k-1)=L([j,k],1:k-1);
            p([k,j])=p([j,k]);
        end
        A(k+1:n,k)=A(k+1:n,k)/A(k,k);
        A(k+1:n,k+1:n)=A(k+1:n,k+1:n)-A(k+1:n,k)*A(k,k+1:n);
    else
        error('Matrix A ist singulaer')
    end
end
U=triu(A);
L=tril(A,-1)+eye(n);
end