function x=linqrgl(A,b,typ)
% function x=linqrgl(A,b,typ)
% Berechnet die Loesung eines linearen Gleichungssystems
% Ax=b mit den folgenden QR-Faktorisierungstechniken:
% Givens-, Householder-, Gram-Schmidt- und modifizierte
% Gram-Schmidt-Faktorisierung.
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% A: (m x n)-Matrix
% b: m-dim-Vektor
% typ: String mit == 'givens'  Givens-Rotation
%                    'house'   Householder-Verfahren
%                    'grasch'  mit Gram-Schmidt-Verfahren
%                    'mgrasch' mit modifiziertem 
%                              Gram-Schmidt-Verfahren
%
% x: Loesung des linearen Quadratmittelproblems
% ||b - A*x||2 ==> min 
%
[m,n]=size(A);
x=zeros(n,1);
switch typ
    case 'givens'
        [Q,R]=qrgivens(A);
    case 'house'
        [Q,R]=qrhouse(A);
    case 'grasch'
        [Q,R]=grasch(A);
    case 'mgrasch'
        [Q,R]=mgrasch(A);
    otherwise
        s=['typ kann nur ''givens'', ''house'', ''grasch'' ']
        s=[s,' oder ''mgrasch'' sein']
        error(s)
end
b=Q(:,1:n)'*b;
for k=n:-1:1
    x(k)=(b(k)-R(k,k+1:n)*x(k+1:n))/R(k,k);
end