function x=lingl(A,b,typ)
% function x=lingl(A,b,typ)
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
% Loest das lineares Gleichungssystem A x = b 
% mit waehlbaren Varianten der Gauss-Elimination oder dem 
% klassischen Cholesky-Verfahren und anschliessender  
% Nachiteration (bei typ='pur' oder 'part')  
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% A: (n x n)-Matrix,
% b: n-dimensionaler-Vektor,
% typ: String mit == 'pur' ohne Pivotisierung,
%                    'part' mit partieller Pivotisierung,
%                    'voll' mit vollstaendiger 
%                           Pivotisierung,
%                    'chol' mit Cholesky-Verfahren,
% x: Loesung des linearen Gleichungssystems A x = b.
%
n=length(b);
p=(1:n)';    
switch typ
    case'chol'
        G=cholesky(A);
        D=diag(diag(G));
        U=D*G'; L=G/D;
        bb=b;
    case 'pur'
        [L,U]=lupur(A);
        bb=b;
    case 'part'
        [L,U,p]=lupart(A);
        bb=b(p);
    case 'voll'
        [L,U,p,q]=luvoll(A);
        bb=b(p);
    otherwise
       s=['typ kann nur ''pur'', ''part'', ''voll'' ']
       s=[s,'oder ''chol'' sein'] 
      error(s)    
end
z=vorsubs(L,bb);
x=ruecksubs(U,z);
if strcmp(typ,'voll'),x(q)=x;
elseif strcmp(typ,'pur') || strcmp(typ,'part')
    [x,~,~] = nachit(x,A,b,L,U,p);
end
end