function [ew,ev]=ipotenz(A,q,tol,nmax)
% function [ev,ew]=ipotenz(A,q,[tol,nmax])
% Berechnet fuer die Matrix A den zu q naechstgelegenen 
% Eigenwert und den zugehoerigen Eigenvektor mit der 
% inversen Potenzmethode
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% A: (n x n)-Matrix,
% q: komplexe Zahl 'nahe' am gesuchten Eigenwert,
% tol: gewuenschte relative Genauigkeit,
% nmax: maximale Iterationszahl,
% ev: normierter Eigenvektor von A,
% ew: Eigenwert von A ('nahe' q).
%
[n,m]=size(A);
if n ~= m, error('Matrix A nicht quadratisch!'), end
if nargin == 2, tol=1e-12; nmax=50*n; end
[L,U,p]=lupart(A-q*eye(n));
y=eye(n,1); z=zeros(n,1); ev=z;ew=inf;
for i=1:nmax
    x=y;
for k=1:n
    z(k)=x(k)-L(k,1:k-1)*z(1:k-1);
end
for k=n:-1:1
    y(k)=(z(k)-U(k,k+1:n)*y(k+1:n))/U(k,k);
end
[~,pk]=max(abs(y)); ypk=y(pk);
y=y(p)/ypk;
if norm(x-y)/(norm(y)+eps) < tol
    ew=1/ypk+q; ev(p)=y/norm(y); return
end    
end
disp ('maximale Iterationszahl erreicht')
