function [q,z,c] = hornerq(p,b)
% function [q,z,c] = hornerq(p,b)
% Realisiert die Division eines Polynom n-ten Grades durch 
% ein quadratisches Polynom
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% p: Vektor, der die Koefizienten a(0),...,a(n) von P(x) 
% enthaelt,
% b: Vektor, der die beiden Koeffizienten b(0) und b(1) 
% von R(x) enthaelt,
% q: Vektor, der die Koeffizienten q(0),...,q(n-2) von Q(x) 
% enthaelt,
% z: Wert von A,
% c: Wert von B.
%   
m=length(p);
z=p(m); c=p(m-1); q(m-2)=z;
for i=m-1:-1:2
    zz=z; z=-b(2)*zz+c; c=-b(1)*zz+p(i-1);
    if i>2,  q(i-2)=z;  end
end