function [y,ys] = horner(p,x)
% function [y,ys] = horner(p,x)
% Berechnet fuer ein Polynom n-ten Grades an den Stellen x 
% den Funktionswert und den Wert der Ableitung
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% p: Vektor, der die Koefizienten a(0),...,a(n) 
% von P(x)=a(0)+a(1)x+ ... enthaelt,
% x: Vektor der Stellen, an denen das Polynom ausgewertet 
% werden soll,
% y:  Funktionswerte von P(x),
% ys: Ableitungswerte von P'(x).
%
m=length(p);
y=0*x+p(m); ys=y;
for i=m-1:-1:2
    y=x.*y+p(i);
    ys=x.*ys+y;
end
y=x.*y+p(1);