function [xi,tend,aHxi,ind,ihom,itk] ... 
            = homoto(x0,hmin,hmax,itvor,TOL,N0)
% function [xi,tend,aHxi,ind,ihom,itk] 
%           = homoto(x0,[hmin,hmax,itvor,TOL,N0])
% Implementierung des Homotopie-Verfahrens 
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% x0: Startwert fuer H(x,0) = 0, 
% hmin: minimale Homotopie-Schrittweite aus (0,1],
% hmax: maximale Homotopie-Schrittweite aus (0,1],
% itvor: vorgegebene 'ideale' Iterationsanzahl des 
% Newton-Verfahrens,
% TOL: Toleranz,
% N0: maximale Iterationsschrittanzahl, 
% xi: letzte Iterierte,
% tend: letzter Wert von t, 
% aHxi: Wert von H(xi,tend),
% ind: Information ueber den Rechenverlauf, mit:
% ind=1: Verfahren konvergiert, 'Loesung' x ist berechnet,
% ind=2: Loesung von H(x,0) = 0 kann mit Startwert x0 
% nicht berechnet werden,
% ind=3: Schrittweite h ist 8x verkleinert worden,
% ind=4: maximale Iterationsschrittanzahl N0 ueberschritten,
% ihom: Anzahl der Homotopie-Schritte,
% itk: Gesamtzahl der Newton-Schritte.
%
global t
if nargin <2, hmin=0.005; hmax=0.1; TOL=1e-6; N0=200; ... 
              itvor=3; 
end
itk=0; s=0; t=0; ihom=0;
% Loesung von H(x,0) = 0 wird berechnet
[x0,aHxi,ik,indn] = newtond1(x0);
if indn ~=1 && aHx > TOL, ind=2; tend=t; return, end
itk=itk+ik; h=hmax; xi=x0; zv=0;
while s < 1
    if s+h>1, h=1-s; end
    t=s+h;
    % Loesen von H(x,t)= 0
    [xip1,aHxi,ik,indn] = newtond1(xi);
    itk=itk+ik; fakh=itvor/ik;
    if itk>N0, ind=4; tend=t; return, end    
    if indn == 1 || aHxi < TOL
        if fakh>1, h=min(max(h*fakh,hmin),hmax); end
        xi=xip1; s=t; zv=0; ihom=ihom+1;
    else
        if fakh<1, h=min(max(h*fakh,hmin),hmax); end
        zv=zv+1;
        if zv > 8, ind=3; tend=t; return, end
    end    
end
% H(x,1) = 0 geloest
ind=1; tend=t;
end