function [G,x] = givens(xk,xl)
% function [G,x] = givens(xk,xl)
% Berechnet die (2x2)-Givens-Rotation und den zugehoerigen
% transformierten Vektor
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
% 
% x_k, x_l: Komponenten des zu transformierenden Vektors x,
% G: erzeugte Givens-Rotation,
% x: transformierter Vektor x=(r,0)'.
%
if xl~=0
    r=norm([xk,xl]);
    G=[xk,xl;-xl,xk]/r;
    x=[r;0];
else
    G=eye(2);
    x=[xk;0];
end