function [x,afx,i,ind] = fixp(x0,TOL,N0)
% function [x,i,ind] = fixp(x0,[TOL,N0])
% Berechnet einen Fixpunkt von x=g(x) mit der 
% Fixpunkt-Iteration
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% x0: Startwert,
% TOL: Toleranz, 
% N0: maximale Iterationsschrittanzahl, 
% x: letzte Iterierte, 
% i: benoetigte Anzahl an Iterationen,
% afx: afx=abs(x-g(x)),
% ind: Information ueber den Rechenverlauf, mit:
% ind=1: Verfahren konvergiert, 'Loesung' x ist berechnet,
% ind=2: maximale Iterationsschrittanzahl N0 ueberschritten.
%
x=x0; i=0;
if nargin < 2, TOL=1e-6; N0=100; end
while i< N0
    xn=g(x);
    if abs(xn-x) < TOL*(1+abs(x))
        ind=1; x=xn; afx=abs(x-g(x)); return    
    end
    i=i+1; x=xn;
end
% maximale Iterationsschrittanzahl N0 ueberschritten
afx=abs(x-g(x));
ind=2;