function G=cholesky(A)
% function G=cholesky(A)
% Traditionelle Cholesky-Faktorisierung A = G * G'
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% A: symmetrische, positiv definite (n x n)-Matrix,
% G: untere (n x n)-Dreiecksmatrix-Matrix.
%
[n,m]=size(A); 
if n ~= m, error('Matrix A nicht quadratisch!'), end
for k=1:n
    if A(k,k)<=0, error(['A(k,k) = ',num2str(A(k,k)),' <= 0]']),
    end
    A(k,k)=sqrt(A(k,k));
    A(k+1:n,k)=A(k+1:n,k)/A(k,k);
    A(k+1:n,k+1:n)=A(k+1:n,k+1:n)-A(k+1:n,k)*A(k+1:n,k)';
end
G=tril(A);