function [x,nFx,ind,i]=broyden(x0,TOL,N0)
% function [x,ind,i]=broyden(x0,[TOL,N0])
% Berechnet die Nullstelle von F(x) mit dem 
% Broyden-Verfahren
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% x0: Anfangsapproximation, 
% TOL: Toleranz, 
% N0:  max. Iterationsschrittzahl,
% x letzte Iterierte,
% nFx: norm(F(x)), 
% ind=1 Verfahren konvergiert,
% ind=2 Maximale Iterationsschrittanzahl N0 
%       ueberschritten.
%
n=length(x0); I=eye(n);
if nargin < 2, TOL=1e-12; N0=100*n; end
x=x0;
Jx=Fstrich(x); v=F(x);
% Berechnung der Inversen L=inv(Jx)
i=1; L=Jx\I; z=-L*v; x=x+z;
while i < N0
    w=v; v=F(x);norm(v)
    if norm(v) < TOL
        % Loesung x berechnet
        ind=1;nFx=norm(F(x)); return
    end
    y=v-w; s=-L*y; p=-z'*s;
    L=L+1/p*(z+s)*(z'*L);
    z=-L*v; x=x+z;
    if norm(z) < TOL*(1+norm(x))
        % Loesung x berechnet
        ind=1;nFx=norm(F(x)); return
    end
    i=i+1;
end
nFx=norm(F(x));
ind=2;  % Max. Iterationsschrittanzahl N0 ueberschritten