function [xa,xb,i,ind] = bisek(a,b,TOL,N0)
% function [xa,xb,i,ind] = bisek(a,b,[TOL,N0])
% Berechnet eine Nullstelle f(x) mit 
% dem Bisektionsverfahren
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% a und b: Intervallgrenzen mit a < b und f(a)*f(b)<0, 
% TOL: Toleranz,
% N0: maximale Iterationsschrittanzahl, 
% xa,xb: [xa,xb] verkleinertes Intervall, das eine 
% Nullstelle enthaelt, 
% i: benoetigte Anzahl an Iterationen,
% ind: Information ueber den Rechenverlauf, mit:
% ind=1: Verfahren konvergiert, 'Loesung' x ist berechnet,
% ind=2: maximale Iterationsschrittanzahl N0 ueberschritten.
%
i=0; xa=a; xb=b; fa=f(a);
if nargin < 3, TOL=1e-12; N0=100; end
while i < N0
    x=(xa+xb)/2; fx=f(x);
    if (b-a)/2 < TOL*(1+abs(a))
% x ist 'Loesung'       
        ind=1; return    
    end
    i=i+1;
    if fa*fx > 0
        xa=x; fa=fx;
    else
        xb=x;
    end
end
%   maximale Iterationsschrittanzahl N0 ueberschritten
ind=2;