function Fs=Fstrich(x)
% function Fs=Fstrich(x)
% Berechnet die Jacobi-Matrix mittels 
% Differenzenapproximation
%
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% x: Argument fuer F'(x),
% Fs: Differenzenapproximation von F'(x).
%
fw=F(x); 
n=length(fw);
Fs=zeros(n);
he=sqrt(eps);
for j=1:n
    h=(abs(x(j))+1e-3)*he; 
    xx=x; xx(j)=xx(j)+h;
    fx=F(xx);
    Fs(:,j)=(fx-fw)/h;    
end