clear;
close all;
clc;

%% Zustandsregler mit Beobachter ohne Strgrenkompensation

m   =   0.5;            % gefederte Masse
c   =   50;             % Steifigkeit der vertikalen Federung 
d   =   0.05;           % Dmpferkonstante


w0      =   sqrt(c/m);      % Kennkreisfrequenz
delta =   (d/m)/2;         % Abklingkonstante


wgr = 2*w0;             %Bandbreite Regler
wgb = 4*w0;            %Bandbreite Beobachter

% Zustandsdarstellung der Regelstrecke
A = [0 1; -w0^2 -2*delta];   % Systematrix
B = [0; 1/m];                  % Eingangsmatrix
C = [1 0];                     % Ausgangsmatrix
D = [0];                       % Durchgangsmatrix

Bz = B;                        % Eingangsmatrix Strung 




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%                 Zustandregler ohne Strgrenbeobachter                                %%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%   Transformation der Regelstecken in RNF %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ZR.Tr = [m, 0; 0, m];
ZR.Ar = ZR.Tr * A * inv(ZR.Tr);
ZR.Br = ZR.Tr * B;
ZR.Cr = C * inv(ZR.Tr);
ZR.Dr = D;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%   Transformation der Regelstecken in BNF %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ZR.Tb = [ 2*delta, 1; 1, 0];
ZR.Ab = ZR.Tb * A * inv(ZR.Tb);
ZR.Bb = ZR.Tb * B;
ZR.Cb = C * inv(ZR.Tb);
ZR.Db = D;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%     Parameter fr Reglerkoeffizienten    %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ZR.a0 = w0^2;
ZR.a1 = 2*delta;
ZR.a2 = 1;
ZR.b0 = 1/m;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% Parametrierung des Zustandsregler in RNF %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Polvorgabe gem Butterworth-Filter mit n=2
% s^2+sqrt(2)*wg*s+wg^2
ZR.wg_R=2*w0;                       % in rad/s 

ZR.p0_R = ZR.wg_R^2;
ZR.p1_R = sqrt(2)*ZR.wg_R;
ZR.p2_R = 1;

% Koeffezienten ri der Rckkopplungsmatrix R 
ZR.r1 = ZR.p0_R/ZR.p2_R*ZR.a2-ZR.a0;
ZR.r2 = ZR.p1_R/ZR.p2_R*ZR.a2-ZR.a1;
ZR.R=[ZR.r1 ZR.r2];

% Berechnung des Vorfilterkoeffezienten q1 
ZR.q1=(ZR.a0+ZR.r1)/ZR.b0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Parametrierung des Zustandsschtzers in BNF %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Polvorgabe gem Butterworth-Filter mit n=2
% s^2+sqrt(2)*wg*s+wg^2
ZR.wg_B=10*w0;                       % in rad/s 

ZR.p0_B = ZR.wg_B^2;
ZR.p1_B = sqrt(2)*ZR.wg_B;
ZR.p2_B = 1;

% Koeffezienten ki der Rckfhrmatrix K 
ZR.k1 = ZR.p0_B/ZR.p2_B*ZR.a2-ZR.a0;
ZR.k2 = ZR.p1_B/ZR.p2_B*ZR.a2-ZR.a1;
ZR.K=[ZR.k1; ZR.k2];


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%   Transformation der Regelstecken in RNF %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ZRS.Tr = [m, 0; 0, m];
ZRS.Ar = ZRS.Tr * A * inv(ZRS.Tr);
ZRS.Br = ZRS.Tr * B;
ZRS.Cr = C * inv(ZRS.Tr);
ZRS.Dr = D;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%   Augmentierte Zustandsdarstellung       %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ZRS.Az = [0];
ZRS.Cz = [1];

ZRS.As = [A B*ZRS.Cz; 0 0 ZRS.Az];
ZRS.Bs = [B; 0];
ZRS.Cs = [C 0];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%   Transformation der Regelstecken in BNF %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ZRS.Tb = [0, 0, 1/m; 2*delta, 1, 0; 1, 0, 0];
ZRS.Ab = ZRS.Tb * ZRS.As * inv(ZRS.Tb);
ZRS.Bb = ZRS.Tb * ZRS.Bs;
ZRS.Cb = ZRS.Cs * inv(ZRS.Tb);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%     Parameter fr Reglerkoeffizienten    %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ZRS.a0 = w0^2;
ZRS.a1 = 2*delta;
ZRS.a2 = 1;
ZRS.b0 = 1/m;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% Parametrierung des Zustandsregler in RNF %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Polvorgabe gem Butterworth-Filter mit n=2
% s^2+sqrt(2)*wg*s+wg^2
ZRS.wg_R=2*w0;                       % in rad/s 

ZRS.p0_R = ZRS.wg_R^2;
ZRS.p1_R = sqrt(2)*ZRS.wg_R;
ZRS.p2_R = 1;

% Koeffezienten ri der Rckkopplungsmatrix R 
ZRS.r1 = ZRS.p0_R/ZRS.p2_R*ZRS.a2-ZRS.a0;
ZRS.r2 = ZRS.p1_R/ZRS.p2_R*ZRS.a2-ZRS.a1;
ZRS.R=[ZRS.r1 ZRS.r2];

% Berechnung des Vorfilterkoeffezienten q1 
ZRS.q1=(ZRS.a0+ZRS.r1)/ZRS.b0;

% Berechnung des Vorfilterkoeffezienten qz
ZRS.Bzr = ZRS.Tr * Bz;
ZRS.qz= -inv(ZRS.Cr*inv(ZRS.Ar-ZRS.Br*ZRS.R)*ZRS.Br)*ZRS.Cr*inv(ZRS.Ar-ZRS.Br*ZRS.R)*ZRS.Bzr;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%     Parameter fr Reglerkoeffizienten    %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ZRS.a0 = 0;
ZRS.a1 = w0^2;
ZRS.a2 = 2*delta;
ZRS.a3 = 1;
ZRS.b0 = 0;
ZRS.b1 = 1/m;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Parametrierung des Zustandsschtzers in BNF %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Polvorgabe gem Butterworth-Filter mit n=2
% s^3+2*wg*s^2+2*wg^2*s+wg^3
ZRS.wg_B=10*w0;                       % in rad/s 

ZRS.p0_B = ZRS.wg_B^3;
ZRS.p1_B = 2*ZRS.wg_B^2;
ZRS.p2_B = 2*ZRS.wg_B;
ZRS.p3_B = 1;

% Koeffezienten ki der Rckfhrmatrix K 
ZRS.k1 = ZRS.p0_B/ZRS.p3_B*ZRS.a3-ZRS.a0;
ZRS.k2 = ZRS.p1_B/ZRS.p3_B*ZRS.a3-ZRS.a1;
ZRS.k3 = ZRS.p2_B/ZRS.p3_B*ZRS.a3-ZRS.a2;
ZRS.K=[ZRS.k1; ZRS.k2; ZRS.k3];



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%                              PI-Zustandregler                                          %%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%   Transformation der Regelstecken in RNF %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ZRPI.Tr = [m, 0; 0, m];
ZRPI.Ar = ZRPI.Tr * A * inv(ZRPI.Tr);
ZRPI.Br = ZRPI.Tr * B;
ZRPI.Cr = C * inv(ZRPI.Tr);
ZRPI.Dr = D;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%   Transformation der Regelstecken in BNF %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ZRPI.Tb = [ 2*delta, 1; 1, 0];
ZRPI.Ab = ZRPI.Tb * A * inv(ZRPI.Tb);
ZRPI.Bb = ZRPI.Tb * B;
ZRPI.Cb = C * inv(ZRPI.Tb);
ZRPI.Db = D;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%     Parameter fr Reglerkoeffizienten    %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ZRPI.a0 = w0^2;
ZRPI.a1 = 2*delta;
ZRPI.a2 = 1;
ZRPI.b0 = 1/m;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% Parametrierung des Zustandsregler in RNF %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Polvorgabe gem Binomialverhaltenmit n=2

% ZRPI.wg_R=2*w0;                       % in rad/s 
% ZRPI.snz=-ZRPI.wg_R;
% 
% ZRPI.p0_R = ZRPI.wg_R^3;
% ZRPI.p1_R = 3*ZRPI.wg_R^2;
% ZRPI.p2_R = 3*ZRPI.wg_R;
% ZRPI.p3_R = 1;
% 
% ZRPI.ri = ZRPI.p0_R/ZRPI.p3_R*ZRPI.a2;
% ZRPI.rp = -ZRPI.ri/ZRPI.snz;
% % Koeffezienten ri der Rckkopplungsmatrix R 
% ZRPI.r1 = ZRPI.p1_R/ZRPI.p3_R*ZRPI.a2-ZRPI.a0-ZRPI.rp;
% ZRPI.r2 = ZRPI.p2_R/ZRPI.p3_R*ZRPI.a2-ZRPI.a1;
% ZRPI.R=[ZRPI.r1 ZRPI.r2];
% 
% % Berechnung des dynamischen Vorfiltes 
% ZRPI.q= 1/ZRPI.b0;



% Polvorgabe gem Butterworth-Filter mit n=2
% (s^2+sqrt(2)*wg*s+wg^2)*(s-snz)
%  s^3+(2^(1/2)*wg-snz)*s^2+(wg^2-2^(1/2)*wg*snz)*s-wg^2*snz


ZRPI.wg_R=2*w0;                       % in rad/s 
ZRPI.snz=-ZRPI.wg_R;

ZRPI.p0_R = -ZRPI.wg_R^2*ZRPI.snz;
ZRPI.p1_R = ZRPI.wg_R^2-sqrt(2)*ZRPI.wg_R*ZRPI.snz;
ZRPI.p2_R = sqrt(2)*ZRPI.wg_R-ZRPI.snz;
ZRPI.p3_R = 1;

ZRPI.ri = ZRPI.p0_R/ZRPI.p3_R*ZRPI.a2;
ZRPI.rp = -ZRPI.ri/ZRPI.snz;

% Koeffezienten ri der Rckkopplungsmatrix R 
ZRPI.r1 = ZRPI.p1_R/ZRPI.p3_R*ZRPI.a2-ZRPI.a0-ZRPI.rp;
ZRPI.r2 = ZRPI.p2_R/ZRPI.p3_R*ZRPI.a2-ZRPI.a1;
ZRPI.R=[ZRPI.r1 ZRPI.r2];

% Berechnung des dynamischen Vorfiltes 
ZRPI.q= 1/ZRPI.b0;





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Parametrierung des Zustandsschtzers in BNF %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Polvorgabe gem Butterworth-Filter mit n=2
% s^2+sqrt(2)*wg*s+wg^2
ZRPI.wg_B=10*w0;                       % in rad/s 

ZRPI.p0_B = ZRPI.wg_B^2;
ZRPI.p1_B = sqrt(2)*ZRPI.wg_B;
ZRPI.p2_B = 1;

% Koeffezienten ki der Rckfhrmatrix K 
ZRPI.k1 = ZRPI.p0_B/ZRPI.p2_B*ZRPI.a2-ZRPI.a0;
ZRPI.k2 = ZRPI.p1_B/ZRPI.p2_B*ZRPI.a2-ZRPI.a1;
ZRPI.K=[ZRPI.k1; ZRPI.k2];