
% Transfer function of the plant
num = 500;
den = [1, 105, 500];
Gs = tf(num, den);

% Proportional controller (P-controller)
K_PR_old = 1; % Initial value for the controller gain
delta_dB = 24; % Adjustment for phase margin
K_PR_new = K_PR_old * 10^(delta_dB/20);

% New transfer function with the adjusted controller
G0 = K_PR_new * Gs;

% Bode plot of the open-loop system
fig = figure;
margin(G0); % Bode plot of G0
grid on;