% Define resistance values in ohms
R1 = 10;
R2 = 20;
R3 = 30;
R4 = 40;

% Specify the source voltage and the internal resistance of the source
Us = 12;
Rs = 5;

% Calculate the total resistances of the series and parallel combinations
R_parallel = 1 / (1/R2 + 1/R3); % Parallel resistance of R2 and R3
R_total = R1 + R_parallel + R4; % Total resistance of the circuit

% Calculate the total current using Ohm's law (Us = I * R_total)
I_total = Us / R_total;

% Calculate the voltages across individual resistors in the series and parallel combinations
V_R1 = I_total * R1;
V_R_parallel = I_total * R_parallel;
V_R4 = I_total * R4;

% Calculate the currents in the individual branches
I_R2 = V_R_parallel / R2;
I_R3 = V_R_parallel / R3;

% Display the calculated values
fprintf('Total resistance of the circuit: %.2f ohms\n', R_total);
fprintf('Total current in the circuit: %.2f A\n', I_total);
fprintf('Voltage across R1: %.2f V\n', V_R1);
fprintf('Voltage across R2: %.2f V\n', V_R_parallel);
fprintf('Voltage across R3: %.2f V\n', V_R_parallel);
fprintf('Voltage across R4: %.2f V\n', V_R4);
fprintf('Current through R2: %.2f A\n', I_R2);
fprintf('Current through R3: %.2f A\n', I_R3);