clear all;
close all;
clc;

% Define system parameters
mA = 280 % Proportional body mass [kg]
mR = 45 % Wheel mass [kg]
cA = 16000 % Suspension spring constant [N/m]
dA = 2250 % Suspension damping constant [Ns/m]
cR = 190500 % Wheel spring constant [N/m]

h1 = figure;
h2 = figure;
h3 = figure;
h4 = figure;
t = 0:0.01:4;
u = 0.1*sin(10*t);

for mA = 50:100:350
    % State-space model matrices
    A = [0          0      1     0
         0          0      0     1
        -cA/mA     cA/mA  -dA/mA  dA/mA
         cA/mR -(cA+cR)/mR dA/mR -dA/mR]  % System matrix
    B =  [0
          0
          0
          cR/mR]  % Control/Input matrix
    C = [1  0  0  0] % Output/Observer matrix
    D = 0  % Feedthrough matrix
    % Initial state
    x0 = [1 0 0 0]'
    % Define state-space model
    sys = ss(A,B,C,D);
    figure(h1);
    pzmap(sys);
    grid;
    hold on
    figure(h2);
    step(sys); grid on;
    hold on
    figure(h3);
    initial(sys,x0); grid on;
    hold on
    figure(h4);
    lsim(sys,u,t);
    grid on
    hold on
end

%-----------------System Analysis------------------%
% System eigenvalues = Eigenvalues of the system matrix A
% Stability?
[EigV,EigW] = eig(A) % Or eig(sys)

% Step response/Transfer function
h_step_time = figure;
step(sys); grid on;
set(h_step_time,'NumberTitle','Off','Name','Step Response')

% Impulse response/Weighting function
h_impulse_time = figure;
impulse(sys); grid on;
set(h_impulse_time,'NumberTitle','Off','Name','Impulse Response')

% Eigen-dynamics/Eigen-movement (no external system excitation)
h_initial = figure;
initial(sys,x0); grid on;
set(h_initial,'NumberTitle','Off','Name','Eigen-Movement 1')

% Harmonic excitation
h_sim = figure;
lsim(sys,u,t);
grid;

% State-space representation -> Transfer function matrix
G = tf(sys) % Transfer function matrix

% Poles from the frequency domain representation (FD)
pole(G)

% Pole-zero map
h_pz = figure;
iopzmap(G), grid on;
set(h_pz,'NumberTitle','Off','Name','Pole-Zero Plot')