function X = dft(x)	
% dft computation in the direct form
% function X = dft(x)
%  x : time-domain signal
%  X : dft spectrum of x
N = length(x);	     % length of input signal and dft
w = exp(-1i*2*pi/N); % complex exponential
X = zeros(1,N);	     % allocate memory for dft spectrum
for k = 0:N-1
    wk = w^k;
    for n = 0:N-1
        X(k+1)= X(k+1) + x(n+1)*wk^n;
    end
end
end