clear all
close all 
clc

%% initialization
zero_vec = [0,0,0];
Fx=[1,0,0];
Fy=[0,2,0];
Fz=[0,0,3];
F = sqrt(Fx(1)^2+Fy(2)^2+Fz(3)^2);
disp('The resulting force is: '+string(F))
%% visualization
figure
hold on
grid on

v=[zero_vec;Fx+Fy+Fz];
plot3(v(:,1),v(:,2),v(:,3),'r')
v=[zero_vec;Fx];
plot3(v(:,1),v(:,2),v(:,3),'b--')
v=[Fx;Fx+Fy];
plot3(v(:,1),v(:,2),v(:,3),'b--')
v=[Fx+Fy;Fx+Fy+Fz];
plot3(v(:,1),v(:,2),v(:,3),'b--')

xlabel('$x$','interpreter','latex')
ylabel('$y$','interpreter','latex')
zlabel('$z$','interpreter','latex')
xlim([-1,2])
ylim([-1,3])
zlim([-1,4])