% load data
data=load('data_0_6.txt');
u1=data(:,1);
y1=data(:,2);
% create figure
figure(1);
plot(u1,y1,'bx');
hold on;
grid on;
X=[u1.^2 sin(u1*3) u1 ones(size(u1))];
% parameter estimation
Theta1_hat=X\y1;
var_noise1=(y1-X*Theta1_hat)'*(y1-X*Theta1_hat)/(length(u1)-4);
P1=inv(X'*X)*var_noise1;
disp('Geschätzte 95% Konfidenzintervalle mit Datensatz data_0_6.txt:');
theta1_hat_95_intervall=[Theta1_hat-1.96*sqrt(diag(P1)) ...
    Theta1_hat+1.96*sqrt(diag(P1))]

u=(-3:0.1:15)';
y_without_noise=0.3*u.^2+2*sin(u*3)+.5*u+2;
X=[u.^2 sin(3*u) u ones(size(u))];
P1_y_hat=X*P1*X';
band=1.96*sqrt(diag(P1_y_hat));
yhat=X*Theta1_hat;
plot(u,y_without_noise,'r');
plot(u,yhat,'b')
plot(u,yhat-band,'b.')
plot(u,yhat+band,'b--');
ylim([-10 70]);
xlim([-3 15]);
ylabel('$y$','interpreter','latex');
xlabel('$u$','interpreter','latex');
legend('Messungen','wahre Kennlinie','Prädiktion',...
    'Untere Grenze KI','Obere Grenze KI','Location','northwest');

