omega0=1;
k=[0.2 1 3];
n=0;
for kappa=k
    n=n+1;
    omega=sqrt(omega0^2-kappa^2);
    t=0:0.01:8*pi;
    if(omega==0)
        y=exp(-kappa.*t).*t;
    else
        y=exp(-kappa.*t).*sin(omega*t)/omega;
    end
    if(n==1)
        subplot(2,2,1:2)
    else
        subplot(2,2,n+1)
    end
    plot(t,y)
    xlabel('$t$','Interpreter','latex')
    ylabel('$y$','Interpreter','latex')
    grid on
    axis tight
    legend(['\kappa = ',num2str(kappa)])
end