function integration()
clear all
close all 
clc
%% parameter
a=0;
b=2.0; 
h=0.4;
%% initialization
n=(b-a)/h; 
t=zeros(1,n+1);
y=zeros(1,n+1); 
T=0;
for i=1:n+1
    y(i)=f(t(i));
    t(i+1)=t(i)+h;
    T=T+trapez(t(i),t(i+1),h);
end
disp('Integral between [a,b] (trapetz): '+string(T))
disp('Integral between [a,b] (analytical): '+string( F(b)-F(a) ) )

figure
hold on
grid on
visualize_area(t,y)
plot( linspace(0,2,100),f(linspace(0,2,100)),'k')
xlabel('$t$','interpreter','latex')
ylabel('$f(t)$','interpreter','latex')
end
function t = trapez(t0,t1,h)
t = h*(f(t0)+f(t1))/2;
end
function y = f(t)
y = -t.^2 + 2*t;
end
function y = F(t)
y = -t^3/3 + t^2;
end
function visualize_area(t,y)
for i=1:length(y)-1
    area([t(i),t(i),t(i+1),t(i+1)],[0,y(i),y(i+1),0],'FaceColor','b','FaceAlpha',.3)
end
end