function finite_differences()
clear all
close all 
clc
%% parameter
N = [2,3];
coeff1 = 2;
coeff2 = -1;
coeff3 = -1;
a = 0;
b = 1;
linetypes = ["--.r" "--.b"];
figure
hold on
grid on;
%% system of equations
for i=1:2
    h = (b-a)/(N(i)+1);
    A = diag(coeff1*ones(1,N(i))) + ...
        diag(coeff2*ones(1,N(i)-1),1) + ...
        diag(coeff3*ones(1,N(i)-1),-1);
    g = ones(N(i),1)*2; 
    g(1) = g(1)-3/(h^2);
    g(end) = g(end)-3/(h^2);
    g = g*(-h^2);
    u = inv(A)*g;
    u = [3; u; 3];
    t = a:h:b;
    plot_results(t,u,linetypes(i),N(i)+2)
end
%% exact solution
t_exact=a:h/10:b;
u_exact=solution(t_exact);
plot(t_exact, u_exact,'-k','DisplayName',['exakte Lösung'])
%% visualization
xlim([a b]);
xlabel('$t$','interpreter','latex')
ylabel('$u$','interpreter','latex')
legend('Location','north')
end
function u=solution(t)
n=length(t);
u=zeros(1,n);
for i=1:n
    u(i)=3+t(i)*(t(i)-1);
end
end
function plot_results(t,y,linetype,support_points)
plot(t,y,linetype,'MarkerSize',18,...
    'DisplayName',[num2str(support_points) ' Stützstellen'])
end