

function euler_procedures()
clear all
close all 
clc
%% parameter
a=0;
b=1.0; 
h=0.2;

%% initialization
n=(b-a)/h; 
t=zeros(1,n+2);
y=zeros(3,n+2); 

for i=2:n+2
    t(i+1)=t(i)+h;
    y(1,i+1)=y(1,i)+h*f(t(i));
    y(2,i+1)=y(2,i)+h*f(t(i+1));
    y(3,i+1)=y(3,i-1)+h*2*f(t(i));
end

%% exact solution
t_exact=a:h/10:b;
y_exact=F(t_exact);

%% visualization

figure
hold on
grid on;
plot(t,y(1,:),'.r','MarkerSize',18)
plot(t,y(2,:),'.b','MarkerSize',18)
plot(t,y(3,:),'.m','MarkerSize',18)
plot(t_exact, y_exact,'-k')

xlim([a b]);
xlabel('$t$','interpreter','latex')
ylabel('$y$','interpreter','latex')
legend( 'Vorwärts-Differenzenquotient',...
        'Rückwärts-Differenzenquotient',...
        'Zentrale Differenzenquotient',...
        'exakte Lösung',...
        'Location','northwest')

end
function y=f(t)
y =t^3;
end
function solution=F(t)
n=length(t);
solution=zeros(1,n);
for i=2:n
    solution(i)=t(i)^4/4;
end
end



