function I=simpadap(a,b,tol)
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
% function [I,t]=simpadap(a,b,tol)
% Berechnet int_a^b f(x) dx mit einem adaptiven 
% Verfahren. Basiert auf dem rekursiven Aufruf
% der Simpson-Regel und Verbesserung des Ergebnisses
% mit der Boole-Regel.
%
% a,b: Integrationsgrenzen 
% tol: geforderte Genauigkeit fuer das Integral  
% I: Approximation des Integrals 
%
m=(a+b)/2;
ab=[a,b];
fw(3)=f(b);
fw(1)=f(a);
fw(2)=f(m);
I=(b-a)/6*(fw(1)+4*fw(2)+fw(3));
I=simprek(I,ab,fw,tol);
end
function I=simprek(I,ab,fw,tol)
fl=fw(1);fm=fw(2);fr=fw(3);
a=ab(1);b=ab(2);m=(a+b)/2;
h=b-a;
lm=(a+m)/2;
rm=(m+b)/2;
flm=f(lm);
frm=f(rm);
Il=h/12*(fl+4*flm+fm);
Ir=h/12*(fm+4*frm+fr);
if abs(I-(Il+Ir)) < 15*tol
% klassisches adaptives Simpson
%    I=Il+Ir;
% Boole-Verbesserung 
    I=(h/90)*(7*fl + 32*flm + 12*fm + 32*frm + 7*fr);
else
    Il=simprek(Il,[a,m],[fl,flm,fm],tol/2);
    Ir=simprek(Ir,[m,b],[fm,frm,fr],tol/2);
    I=Il+Ir;
end    
end