function s = simp(a,b,m)
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
% function s = simp(a,b,m)
% Berechnet int_a^b f(x) dx mit der zusammengesetzten
% Simpson-Regel
%
% a,b: Integrationsgrenzen 
% m: Intervall [a,b] wird in 2m Segmente unterteilt  
% s: Approximation des Integrals 
%
h=(b-a)/(2*m); s0=f(a)+f(b); s1=0; s2=0;
for k=1:2*m-1
    x=a+k*h; 
    if mod(k,2)==0
        s1=s1+f(x);  % k gerade
    else
        s2=s2+f(x);  % k ungerade
    end
end
s=h*(s0+2*s1+4*s2)/3;
end