function yt=newtonval(a,x,t)
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
% function [yt]=newtonval(a,x,t)
% Berechnet fuer die Newton-Darstellung des 
% Interpolationspolynoms die Funktionswerte
% Pn(t), t=(t1, ..., tm), ti aus [a,b]
%
% a: Vektor der Koeffizienten des Interpolationspolynoms
% x: Vektor der Stuetzstellen x(1) < x(2) ,..., x(n) < x(n)
% t: Vektor der Stellen, an denen das Polynom ausgewertet 
% werden soll
% yt: Funktionswerte yt=Pn(t)
%
n=length(a);
yt=a(n)*(t-x(n-1));
for i=n-1:-1:2
    yt=(yt+a(i)).*(t-x(i-1));
end
yt=yt+a(1);
end