function a=newtoninter(x,y)
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
% function a=newtoninter(x,y)
% Berechnet die Koeffizienten der Newton-Darstellung 
% des Interpolationspolynoms
%
% x: Vektor der Stuetzstellen x(1) < x(2) ,..., x(n) < x(n)
% y: Vektor der Stuetzwerte y(1),...,y(n)
% a: Vektor der Koeffizienten des Interpolationspolynoms
%
x=x(:);
n=length(x);
y=y(:);
for i=1:n-1    
    y(i+1:n)=(y(i+1:n)-y(i:n-1))./(x(i+1:n)-x(1:n-i));
end
a=y;