% Hauptprogramm fuer die Anwendung von polyint2d
% am Beispiel der Himmelblau-Funktion
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%
% clear, close all  % bei Bedarf aktivieren/deaktivieren
%-------------------------
% Zeichnen der Funktion in [-5,5]x[-5,5]
[u,v]=meshgrid(-5:5);
w=himmelblau(u,v);
figure('Name','2D-Interpolation')
clf
grayhell=0*gray+.5;
colormap (grayhell)
% Zeichnen der Himmelblau-Funktion
surf(u,v,w,'FaceAlpha',.3)
hold on
%--------------------------
% Dimension von x und y
n=5;
% Maschenweite in x- und y-Richtung 
h=-1;k=-1;
% Anfangspunkt x1 und y1
x1=5; y1=5;
% Erzeugen der Vektoren x und y
x=x1+(0:n-1)*h;
y=y1+(0:n-1)*k;
% Berechnung der Funktionswerte z=f(x,y) (als Matrix)
[xn,yn]=meshgrid(x,y);
z=himmelblau(xn,yn);
%--------------------------
% Zeichnen der Interpolations-Punkte (Dreieck) und Werte
zn=z+rot90(tril(NaN*z,-1));
plot3(xn(:),yn(:),zn(:),'k*','MarkerSize',7)
%--------------------------
% Gitter der Interpolationsstellen xint und yint
% mit Schrittweite 1/4 erzeugt durch meshgrid
[xint,yint]=meshgrid(-5:.25:5);
% Berechnung der Interpolationswerte zint=Pn(xint,yint)
zint=polyint2d(x,y,z,xint,yint);
%--------------------------
% Zeichnen der Interpolationspunkte (ximt,yint,zint)
plot3(xint(:),yint(:),zint(:),'k.','MarkerSize',7)
%--------------------------
% Beschriftung
title('f(x,y)=(x^2+y-11)^2+(x+y^2-7)^2')
xlabel('x')
ylabel('y')
zlabel('f(x,y)')
%legend('Stuetzpunkte','interpolierte Punkte','Location','northwest')
legend('Funktion','Stuetzwerte','interpolierte Werte','Location','northwest')
gitter