function y=fidft(x)
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
% function y=fidft(x)
% Berechnet die Schnelle Inverse Diskrete 
% Fourier-Transformation (FIDFT) fuer den Vektor x
%
% x: Eingabevektor der Dimension 2^k   
% y: FIDFT von x (Vektor der Dimension 2^k)
%  
n=max(size(x));
if n==1
       y=x;
else
    m=n/2; u=zeros(1,m); g=u; g(:)=x(1:2:n); u(:)=x(2:2:n);
    yg=fidft(g); yu=fidft(u);
    w=exp(2*pi*1i/n); vw=w.^(0:(m-1)); z=yu.*vw;
    y(1:m)=(yg+z); y(m+1:n)=(yg-z);
end
end