function a=vandermonde(x,y)
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
% function a=vandermonde(x,y)
% Berechnet die Koeffizienten des Interpolationspolynoms
% mittels Vandermonde-Amsatz
%
% x: Vektor der Stuetzstellen x(1) < x(2) ,..., x(n) < x(n)
% y: Vektor der Stuetzwerte y(1),...,y(n)
% a: Vektor der Koeffizienten des Interpolationspolynoms
%
x=x(:); n=length(x); V=ones(n,n); y=y(:);
for i=2:n
% j-te Spalte von der Vandermonde-Matrix wird gebildet
    V(:,i)=x.*V(:,i-1);
end
% falls Programm aus Band 1 verwendet werden soll:
% a=lingl(V,y,'part'); 
% alternativ:
a=V\y;  
end