function y=splineval(a,b,c,d,x,t)
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
% function y=splineval(a,b,c,d,x,t)
% Berechnet die Funktionswerte der Splinefunktion S(t)
% fuer t=(t1, ..., tm), ti aus [a,b]
%
% a,b,c,d: zuvor mit nspline oder espline berechnete 
% Koeffizienten des Splines
% x: Vektor der Stuetzstellen, die in espline oder nspline 
%    verwendet wurden
% t: Vektor der Stellen, an denen der Spline ausgewertet 
% werden soll 
%
% y: Vektor der Werte des Splines an den Ausgabestellen t
%
n=length(x)-1;
m=length(t);
y=zeros(m,1);
for i=1:m
    yi=a(x==t(i));
    if ~isempty(yi)
        y(i)=yi;
    else
        for j=1:n
            if x(j) < t(i) && t(i) < x(j+1)
                dd=t(i)-x(j);
                y(i)=a(j)+dd*(b(j)+dd*(c(j)+dd*d(j)));
                break
            end
        end
    end
end
end