function r = rom(a,b,n)
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
%function r = rom(a,b,n)
% Zur Berechnung von int_a^b f(x) dx wird mit der
% Romberg-Integration die Tabelle 4.14 erzeugt
%
% a,b: Integrationsgrenzen 
% n: Tableau-Tiefe
% r: Romberg-Tableau 
%
h=(b-a); r=zeros(n); r(1,1)=h*(f(a)+f(b))/2;
for i=2:n
    s=0; 
    for k=1:2^(i-2), s=s+f(a+(k-.5)*h); end
    r(i,1)=(r(i-1,1)+h*s)/2;
    for j=2:i
        r(i,j)=(4^(j-1)*r(i,j-1)-r(i-1,j-1))/(4^(j-1)-1);
    end
    h=h/2;
end
end