function zint=polyint2d(x,y,z,xint,yint)
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
% function zint=polyint2d(x,y,z,xint,yint)
% Berechnet die Koeffizienten des zweidimensionalen 
% Interpolationspolynoms Pn(x,y) fuer die nach der 
% Formel (1.128) vorzugebenden Stuetzpunkte (xi,yj)
% und den zugehoerigen Funktionswerten zij.
% Des Weiteren wird an den Stellen (xint,yint)
% der Werte des Polynoms zint=Pn(xint,yint) berechnet.
% 
% x: Vektor x=(x1,...,xn), mit xi=x1+(i-1)h
% y: Vektor y=(y1,...,yn), mit yj=y1+(j-1)k
% z: Matrix z=(zij), i,j=1,..,n
% xint: Matrix xint=(xintlk), l=1,...,m, k=1,...,s
% yint: Matrix yint=(yintlk), l=1,...,m, k=1,...,s
%
n=length(x)
h=x(2)-x(1); k=y(2)-y(1); 
if n > 1
    n1=n-1;dx=zeros(n1);dy=dx;
    for j=1:n-1
        for i=1:n-j
            dx(j,i)=z(j,i+1)-z(j,i);
            dy(j,i)=z(j+1,i)-z(j,i);
        end
    end
    dx0=dx(1,1); dy0=dy(1,1);
end
if n > 2
    n2=n-2;dx2=zeros(n2);dy2=dx2;dxy=dx2;
    for j=1:n-2
        for i=1:n-j-1
            dx2(j,i)=dx(j,i+1)-dx(j,i);
            dy2(j,i)=dy(j+1,i)-dy(j,i);
            dxy(j,i)=dx(j+1,i)-dx(j,i);
        end
    end
    dx20=dx2(1,1); dy20=dy2(1,1);dxy0=dxy(1,1); 
end
if n > 3
    n3=n-3;dx3=zeros(n3);dy3=dx3;dx2y=dx3;dxy2=dx3;
    for j=1:n-3
        for i=1:n-j-2
            dx3(j,i)=dx2(j,i+1)-dx2(j,i); 
            dx2y(j,i)=dx2(j+1,i)-dx2(j,i);
            dxy2(j,i)=dxy(j+1,i)-dxy(j,i);
            dy3(j,i)=dy2(j+1,i)-dy2(j,i);
        end
    end
    dx30=dx3(1,1); dy30=dy3(1,1); dx2y0=dx2y(1,1); dxy20=dxy2(1,1);
end
if n > 4
    n4=n-4;dx4=zeros(n4);dy4=dx4;dx3y=dx4;dx2y2=dx4;dxy3=dx4;
    for j=1:n-4
        for i=1:n-j-3
            dx4(j,i)=dx3(j,i+1)-dx3(j,i); 
            dx3y(j,i)=dx3(j+1,i)-dx3(j,i);
            dx2y2(j,i)=dx2y(j+1,i)-dx2y(j,i);
            dxy3(j,i)=dxy2(j+1,i)-dxy2(j,i);
            dy4(j,i)=dy3(j+1,i)-dy3(j,i);
        end
    end
    dx40=dx4(1,1); dy40=dy4(1,1);
    dx3y0=dx3y(1,1); dx2y20=dx2y2(1,1); dxy30=dxy3(1,1); 
end
z0=z(1,1); 
zint=z0 ;
if n > 1
    zint=zint ...
        +(xint-x(1))/h*dx0 + (yint-y(1))/k*dy0;
end
if n > 2
    zint=zint ...
        +(xint-x(1)).*(xint-x(2))/h^2/2*dx20 ...        
        +(xint-x(1)).*(yint-y(1))/h/k*dxy0 ...
        +(yint-y(1)).*(yint-y(2))/2/k^2*dy20;
end
if n > 3
    zint=zint ...
        +(xint-x(1)).*(xint-x(2)).*(xint-x(3))/6/h^3*dx30 ...
        +(xint-x(1)).*(xint-x(2)).*(yint-y(1))/2/h^2/k*dx2y0 ...
        +(xint-x(1)).*(yint-y(1)).*(yint-y(2))/2/h/k^2*dxy20 ...
        +(yint-y(1)).*(yint-y(2)).*(yint-y(3))/6/k^3*dy30;
end
if n > 4
    zint=zint ...
        +(xint-x(1)).*(xint-x(2)).*(xint-x(3)).*(xint-x(4))/24/h^4*dx40 ...
        +(xint-x(1)).*(xint-x(2)).*(xint-x(3)).*(yint-y(1))/6/h^3/k*dx3y0 ...
        +(xint-x(1)).*(xint-x(2)).*(yint-y(1)).*(yint-y(2))/4/h^2/k^2*dx2y20 ...
        +(xint-x(1)).*(yint-y(1)).*(yint-y(2)).*(yint-y(3))/6/h/k^3*dxy30 ...
        +(yint-y(1)).*(yint-y(2)).*(yint-y(3)).*(yint-y(4))/24/k^4*dy40 ;
end
end