function [Q,R]=mgrasch(A)
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
% function [Q,R]=mgrasch(A)
% Berechnet die reduzierte QR-Faktorisierung von A
% mit dem modifizierten Gram-Schmidt-Verfahren
%
% A: (m x n)-Matrix, m>=n
% Q: spaltenorthonormale Matrix (m x n)-Matrix
% R: obere (n x n)-Dreiecksmatrix
%
[m,n]=size(A);
if n>m, error('Dimensionsfehler (n>m)'),end
Q=zeros(m,n);
R=zeros(n);
for k=1:n
    Q(:,k)=A(:,k);
    for i=1:k-1
        R(i,k)=Q(:,i)'*Q(:,k);
        Q(:,k)=Q(:,k)-R(i,k)*Q(:,i);
    end
    R(k,k)=norm(Q(:,k));
    if R(k,k) == 0
        error('Matrix A hat nicht vollen Rang')
    end
    Q(:,k)=Q(:,k)/R(k,k);
end
end